unit VCTOOL32;{Feb14/97 9:30am}

interface

uses WinTypes, VCType32;

function VCLoadVCTOOL32 : boolean;
procedure VCFreeVCTOOL32;
procedure VCAddPopupCommand(szNativeCmd: PChar; iPlacement: smallint); stdcall;
procedure VCAdjoiningToMEP(var iError: smallint); stdcall;
procedure VCAlignSelected; stdcall;
procedure VCAngularDim; stdcall;
procedure VCArc2Pt; stdcall;
procedure VCArc3Pt; stdcall;
procedure VCArrayCopySelected; stdcall;
procedure VCAttributeAttach; stdcall;
procedure VCAttributeCreate; stdcall;
procedure VCAttributeEdit; stdcall;
procedure VCAttributeEmbed; stdcall;
procedure VCAttributeMove; stdcall;
procedure VCAttributeMultiAttach; stdcall;
procedure VCBezEdit; stdcall;
procedure VCBezierSingle; stdcall;
procedure VCBooleanAdd(var iError: smallint); stdcall;
procedure VCBooleanIntersect(var iError: smallint); stdcall;
procedure VCBooleanSubtract(var iError: smallint); stdcall;
procedure VCBoundaryFill; stdcall;
procedure VCBoundaryHatch; stdcall;
procedure VCChamfer; stdcall;
procedure VCChangeAtbDisplay(var iError: smallint; tfDisplay: wordbool); stdcall;
procedure VCChangeAtbLabelDisplay(var iError: smallint; tfDisplay: wordbool); stdcall;
procedure VCChangeSelected(var ea: EAttr); stdcall;
procedure VCChangeSymPlacementColor(var iError: smallint; tfUsePlacementColor: wordbool; iNewColor: smallint); stdcall;
procedure VCCircle2Pt; stdcall;
procedure VCCircle3Pt; stdcall;
procedure VCCircleDiameter; stdcall;
procedure VCClearDrawing(hW: Longint); stdcall;
procedure VCClearDrawingNoPrompt(hW: Longint); stdcall;
procedure VCContBezier; stdcall;
procedure VCCopySelected; stdcall;
procedure VCCopyToLayer(var iError: smallint; iLayer: smallint);stdcall;
procedure VCCornerTrim; stdcall;
function VCCreateOleClass(var iError: smallint; OleDllName: PChar; OleClassName: PChar):Longint; stdcall;
procedure VCCurve; stdcall;
procedure VCDatum(var iError: smallint); stdcall;
procedure VCDeleteOleClass(var iError: smallint; id: Longint); stdcall;
procedure VCDeletePopupMenu(tf: wordbool); stdcall;
procedure VCDestroyContextMenu(var iError: smallint; hMenu: longint);stdcall;
procedure VCDiameterDim; stdcall;
procedure VCDigConfig; stdcall;
procedure VCDigDrawingAlign; stdcall;
procedure VCDimEdit; stdcall;
procedure VCDimMoveArc; stdcall;
procedure VCDimMoveLine; stdcall;
procedure VCDimMoveText; stdcall;
procedure VCDimPoint(var iError: smallint); stdcall;
procedure VCDimSlideText; stdcall;
procedure VCDispatchCommand; stdcall;
procedure VCDispatchNextPoint; stdcall;
procedure VCDllRun(var iError: smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar); stdcall;
procedure VCEdit; stdcall;
procedure VCEditAbort; stdcall;
procedure VCEditChange; stdcall;
procedure VCEditComplete; stdcall;
procedure VCEllipse; stdcall;
procedure VCEllipticalArcStartSpan; stdcall;
procedure VCEraseLast; stdcall;
procedure VCEraseSelected; stdcall;
procedure VCExplode; stdcall;
procedure VCExtend; stdcall;
procedure VCFillSelected; stdcall;
procedure VCFillet; stdcall;
procedure VCFitScaleSelected; stdcall;
function VCGetCurrentToolContextMenu(var iError: smallint; hInMenu: Longint): smallint; stdcall;
function VCGetDatumMode(var iError: smallint):Smallint; stdcall;
function VCGetPrompt(iPromptIndex: smallint; szPrompt: PChar):Smallint; stdcall;
function VCGetRibbolog:Smallint; stdcall;
function VCGetToolID:Smallint; stdcall;
function VCGetUserToolState(var iError: smallint):Smallint; stdcall;
procedure VCGridOrigin; stdcall;
procedure VCHatchSelected; stdcall;
procedure VCIrregularPolygon; stdcall;
procedure VCLeader; stdcall;
procedure VCLeaderEdit; stdcall;
procedure VCLike(hw: Longint; ch: PChar); stdcall;
procedure VCLine; stdcall;
procedure VCLineContinuous; stdcall;
procedure VCLinearDim; stdcall;
procedure VCLoadAscii(var iError: smallint; szAscii: PChar); stdcall;
procedure VCLoadLnt; stdcall;
procedure VCMButtonDown(lParam: Longint; wParam: smallint); stdcall;
procedure VCMLine; stdcall;
procedure VCMatchEntity; stdcall;
procedure VCMatchTool; stdcall;
procedure VCMeasureAngle2; stdcall;
procedure VCMeasureAngle3; stdcall;
procedure VCMeasureArea; stdcall;
procedure VCMeasureDistance; stdcall;
procedure VCMerge(pName: PChar); stdcall;
procedure VCMergePolygonsTool(var iError: smallint); stdcall;
procedure VCMirrorSelected; stdcall;
procedure VCModBreak; stdcall;
procedure VCMovePoint; stdcall;
procedure VCMoveSelected; stdcall;
procedure VCMoveToLayer(var iError: smallint; iLayer: smallint); stdcall;
procedure VCMultipleCopy; stdcall;
procedure VCNewHandle; stdcall;
procedure VCOffsetMEP(var iError: smallint); stdcall;
procedure VCOffsetPnt; stdcall;
procedure VCOleClassMethodInvoke(var iError: smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar); stdcall;
procedure VCOrdinateDim(var iError: smallint); stdcall;
procedure VCPackData(hW: Longint); stdcall;
function VCPastable:wordbool; stdcall;
procedure VCPaste; stdcall;
procedure VCPlaceCurrentSymbol; stdcall;
procedure VCPoint; stdcall;
procedure VCPopupButton(lParam: Longint; wParam: smallint); stdcall;
procedure VCPurgeLnt; stdcall;
procedure VCRButtonDown(lParam: Longint; wParam: smallint); stdcall;
procedure VCRFSize(var iError: smallint); stdcall;
procedure VCRFZoomAll(var iError: smallint); stdcall;
procedure VCRFZoomArea(var iError: smallint); stdcall;
procedure VCRFZoomIn(var iError: smallint); stdcall;
procedure VCRFZoomOut(var iError: smallint); stdcall;
procedure VCRFZoomPan(var iError: smallint); stdcall;
procedure VCRFZoomPrevious(var iError: smallint); stdcall;
procedure VCRFZoomRegen(var iError: smallint); stdcall;
procedure VCRFZoomValue(var iError: smallint); stdcall;
procedure VCRFZoomView(var iError: smallint); stdcall;
procedure VCRPolygonCenter; stdcall;
procedure VCRPolygonSide; stdcall;
procedure VCRadCopySelected; stdcall;
procedure VCRadialDim; stdcall;
procedure VCRectangle2Pt; stdcall;
procedure VCRectangle3Pt; stdcall;
procedure VCRedo; stdcall;
procedure VCRefFrameCreate(var iError: smallint); stdcall;
procedure VCRefFramePlace(var iError: smallint); stdcall;
procedure VCRegenArea; stdcall;
procedure VCReplaceSymbol(szFrom: PChar; szTo: PChar; tfSelectedOnly: wordbool); stdcall;
procedure VCRotateSelected; stdcall;
procedure VCRun(szName: PChar); stdcall;
procedure VCRunNested(szName: PChar); stdcall;
procedure VCRunNestedDll; stdcall;
procedure VCScaleSelected; stdcall;
procedure VCSeedFill; stdcall;
procedure VCSeedHatch; stdcall;
procedure VCSelect; stdcall;
procedure VCSelectAdjoining; stdcall;
procedure VCSelectCrossingWindow; stdcall;
procedure VCSelectLastEntity; stdcall;
procedure VCSelectLastObject(var iError: smallint); stdcall;
procedure VCSelectObject; stdcall;
procedure VCSelectWindow; stdcall;
procedure VCSelectionExtend; stdcall;
procedure VCSelectionFilter(CmdID: smallint; id: smallint); stdcall;
procedure VCSelectionRibalog(id: smallint); stdcall;
procedure VCSelectionTrim; stdcall;
procedure VCSelectionTrimSingleTarget(var iError: smallint); stdcall;
procedure VCSetBasepoint; stdcall;
procedure VCSetDatumMode(var iError: smallint; iMode: smallint); stdcall;
function VCSetPrompt(iPromptIndex: smallint; szPrompt: PChar):Boolean; stdcall;
procedure VCSetRibbolog(id: smallint); stdcall;
procedure VCSetUserTool(iStates: smallint; szNativeCmd: PChar; szFirstPrompt: PChar); stdcall;
procedure VCSetUserToolState(var iError: smallint; iNewState: smallint); stdcall;
procedure VCSnapArcCenter; stdcall;
procedure VCSnapCloseGeom; stdcall;
procedure VCSnapClosestPoint; stdcall;
procedure VCSnapEndPoint; stdcall;
procedure VCSnapInt; stdcall;
procedure VCSnapLastPoint(lParam: Longint; wParam: smallint); stdcall;
procedure VCSnapMid2Points; stdcall;
procedure VCSnapMidPoint; stdcall;
procedure VCSnapNearPoint(lParam: Longint; wParam: smallint); stdcall;
procedure VCSnapParallel; stdcall;
procedure VCSnapPercent; stdcall;
procedure VCSnapPerpendicular; stdcall;
procedure VCSnapQuad; stdcall;
procedure VCSnapTangent; stdcall;
procedure VCSpecificAttributeAttach(lParam: Longint); stdcall;
procedure VCSplitPolygonTool(iError: smallint); stdcall;
procedure VCStretchSelected; stdcall;
procedure VCSymbolCreate; stdcall;
procedure VCSymbolExplode; stdcall;
procedure VCSymbolPlace(szName: PChar); stdcall;
procedure VCTextManager; stdcall;
procedure VCTextTool; stdcall;
procedure VCTracking; stdcall;
procedure VCTrim; stdcall;
procedure VCUndo; stdcall;
procedure VCUndoLastVertex; stdcall;
procedure VCUpdateTool; stdcall;
procedure VCUserMatch(id: smallint); stdcall;
procedure VCUserPoint; stdcall;
procedure VCWindowStretch; stdcall;
procedure VCZoomArea; stdcall;
procedure VCZoomIn; stdcall;
procedure VCZoomOut; stdcall;
procedure VCZoomPan; stdcall;
procedure VCZoomValue; stdcall;

implementation

var
    hInst : THandle;

function VCLoadVCTOOL32 : boolean;
begin
  hInst := LoadLibrary('VCTOOL32.DLL');
  result := hInst >= 32;
end;

procedure VCFreeVCTOOL32;
begin
  FreeLibrary(hInst);
end;

type TVCAddPopupCommand = procedure (szNativeCmd: PChar; iPlacement: smallint); stdcall;

procedure VCAddPopupCommand (szNativeCmd: PChar; iPlacement: smallint);
var aproc : TVCAddPopupCommand;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAddPopupCommand');
  if @aproc <> nil then
      aproc(szNativeCmd, iPlacement);
end;

type TVCAdjoiningToMEP = procedure (var iError: smallint); stdcall;

procedure VCAdjoiningToMEP (var iError: smallint);
var aproc : TVCAdjoiningToMEP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAdjoiningToMEP');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCAlignSelected = procedure ; stdcall;

procedure VCAlignSelected ;
var aproc : TVCAlignSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAlignSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCAngularDim = procedure ; stdcall;

procedure VCAngularDim ;
var aproc : TVCAngularDim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAngularDim');
  if @aproc <> nil then
      aproc;
end;

type TVCArc2Pt = procedure ; stdcall;

procedure VCArc2Pt ;
var aproc : TVCArc2Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCArc2Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCArc3Pt = procedure ; stdcall;

procedure VCArc3Pt ;
var aproc : TVCArc3Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCArc3Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCArrayCopySelected = procedure ; stdcall;

procedure VCArrayCopySelected ;
var aproc : TVCArrayCopySelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCArrayCopySelected');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeAttach = procedure ; stdcall;

procedure VCAttributeAttach ;
var aproc : TVCAttributeAttach;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeAttach');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeCreate = procedure ; stdcall;

procedure VCAttributeCreate ;
var aproc : TVCAttributeCreate;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeCreate');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeEdit = procedure ; stdcall;

procedure VCAttributeEdit ;
var aproc : TVCAttributeEdit;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeEdit');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeEmbed = procedure ; stdcall;

procedure VCAttributeEmbed ;
var aproc : TVCAttributeEmbed;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeEmbed');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeMove = procedure ; stdcall;

procedure VCAttributeMove ;
var aproc : TVCAttributeMove;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeMove');
  if @aproc <> nil then
      aproc;
end;

type TVCAttributeMultiAttach = procedure ; stdcall;

procedure VCAttributeMultiAttach ;
var aproc : TVCAttributeMultiAttach;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAttributeMultiAttach');
  if @aproc <> nil then
      aproc;
end;

type TVCBezEdit = procedure ; stdcall;

procedure VCBezEdit ;
var aproc : TVCBezEdit;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBezEdit');
  if @aproc <> nil then
      aproc;
end;

type TVCBezierSingle = procedure ; stdcall;

procedure VCBezierSingle ;
var aproc : TVCBezierSingle;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBezierSingle');
  if @aproc <> nil then
      aproc;
end;

type TVCBooleanAdd = procedure (var iError: smallint); stdcall;

procedure VCBooleanAdd (var iError: smallint);
var aproc : TVCBooleanAdd;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBooleanAdd');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCBooleanIntersect = procedure (var iError: smallint); stdcall;

procedure VCBooleanIntersect (var iError: smallint);
var aproc : TVCBooleanIntersect;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBooleanIntersect');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCBooleanSubtract = procedure (var iError: smallint); stdcall;

procedure VCBooleanSubtract (var iError: smallint);
var aproc : TVCBooleanSubtract;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBooleanSubtract');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCBoundaryFill = procedure ; stdcall;

procedure VCBoundaryFill ;
var aproc : TVCBoundaryFill;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBoundaryFill');
  if @aproc <> nil then
      aproc;
end;

type TVCBoundaryHatch = procedure ; stdcall;

procedure VCBoundaryHatch ;
var aproc : TVCBoundaryHatch;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBoundaryHatch');
  if @aproc <> nil then
      aproc;
end;

type TVCChamfer = procedure ; stdcall;

procedure VCChamfer ;
var aproc : TVCChamfer;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChamfer');
  if @aproc <> nil then
      aproc;
end;

type TVCChangeAtbDisplay = procedure (var iError: smallint; tfDisplay: wordbool); stdcall;

procedure VCChangeAtbDisplay (var iError: smallint; tfDisplay: wordbool);
var aproc : TVCChangeAtbDisplay;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeAtbDisplay');
  if @aproc <> nil then
      aproc(iError, tfDisplay);
end;

type TVCChangeAtbLabelDisplay = procedure (var iError: smallint; tfDisplay: wordbool); stdcall;

procedure VCChangeAtbLabelDisplay (var iError: smallint; tfDisplay: wordbool);
var aproc : TVCChangeAtbLabelDisplay;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeAtbLabelDisplay');
  if @aproc <> nil then
      aproc(iError, tfDisplay);
end;

type TVCChangeSelected = procedure (var ea: EAttr); stdcall;

procedure VCChangeSelected (var ea: EAttr);
var aproc : TVCChangeSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeSelected');
  if @aproc <> nil then
      aproc(ea);
end;

type TVCChangeSymPlacementColor = procedure (var iError: smallint; tfUsePlacementColor: wordbool; iNewColor: smallint); stdcall;

procedure VCChangeSymPlacementColor (var iError: smallint; tfUsePlacementColor: wordbool; iNewColor: smallint);
var aproc : TVCChangeSymPlacementColor;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeSymPlacementColor');
  if @aproc <> nil then
      aproc(iError, tfUsePlacementColor, iNewColor);
end;

type TVCCircle2Pt = procedure ; stdcall;

procedure VCCircle2Pt ;
var aproc : TVCCircle2Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCircle2Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCCircle3Pt = procedure ; stdcall;

procedure VCCircle3Pt ;
var aproc : TVCCircle3Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCircle3Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCCircleDiameter = procedure ; stdcall;

procedure VCCircleDiameter ;
var aproc : TVCCircleDiameter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCircleDiameter');
  if @aproc <> nil then
      aproc;
end;

type TVCClearDrawing = procedure (hW: Longint); stdcall;

procedure VCClearDrawing (hW: Longint);
var aproc : TVCClearDrawing;
begin
  @aproc :=  GetProcAddress(hInst, 'VCClearDrawing');
  if @aproc <> nil then
      aproc(hW);
end;

type TVCClearDrawingNoPrompt = procedure (hW: Longint); stdcall;

procedure VCClearDrawingNoPrompt (hW: Longint);
var aproc : TVCClearDrawingNoPrompt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCClearDrawingNoPrompt');
  if @aproc <> nil then
      aproc(hW);
end;

type TVCContBezier = procedure ; stdcall;

procedure VCContBezier ;
var aproc : TVCContBezier;
begin
  @aproc :=  GetProcAddress(hInst, 'VCContBezier');
  if @aproc <> nil then
      aproc;
end;

type TVCCopySelected = procedure ; stdcall;

procedure VCCopySelected ;
var aproc : TVCCopySelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCopySelected');
  if @aproc <> nil then
      aproc;
end;

type TVCCopyToLayer = procedure (var iError: smallint; iLayer: smallint);stdcall;

procedure VCCopyToLayer(var iError: smallint; iLayer: smallint);stdcall;
var aproc : TVCCopyToLayer;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCopyToLayer');
  if @aproc <> nil then
      aproc(iError, iLayer);
end;

type TVCCornerTrim = procedure ; stdcall;

procedure VCCornerTrim ;
var aproc : TVCCornerTrim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCornerTrim');
  if @aproc <> nil then
      aproc;
end;

type TVCCreateOleClass = function (var iError: smallint; OleDllName: PChar; OleClassName: PChar):Longint; stdcall;

function VCCreateOleClass (var iError: smallint; OleDllName: PChar; OleClassName: PChar):Longint;
var aproc : TVCCreateOleClass;
begin
    result := Longint(0);
  @aproc :=  GetProcAddress(hInst, 'VCCreateOleClass');
  if @aproc <> nil then
    result :=   aproc(iError, OleDllName, OleClassName);
end;

type TVCCurve = procedure ; stdcall;

procedure VCCurve ;
var aproc : TVCCurve;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCurve');
  if @aproc <> nil then
      aproc;
end;

type TVCDatum = procedure (var iError: smallint); stdcall;

procedure VCDatum (var iError: smallint);
var aproc : TVCDatum;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDatum');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCDeleteOleClass = procedure (var iError: smallint; id: Longint); stdcall;

procedure VCDeleteOleClass (var iError: smallint; id: Longint);
var aproc : TVCDeleteOleClass;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDeleteOleClass');
  if @aproc <> nil then
      aproc(iError, id);
end;

type TVCDeletePopupMenu = procedure (tf: wordbool); stdcall;

procedure VCDeletePopupMenu (tf: wordbool);
var aproc : TVCDeletePopupMenu;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDeletePopupMenu');
  if @aproc <> nil then
      aproc(tf);
end;


type TVCDestroyContextMenu = procedure (var iError: smallint; hMenu: longint);stdcall;

procedure VCDestroyContextMenu(var iError: smallint; hMenu: longint);stdcall;
var aproc : TVCDestroyContextMenu;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDestroyContextMenu');
  if @aproc <> nil then
      aproc(iError, hMenu);
end;

type TVCDiameterDim = procedure ; stdcall;

procedure VCDiameterDim ;
var aproc : TVCDiameterDim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDiameterDim');
  if @aproc <> nil then
      aproc;
end;

type TVCDigConfig = procedure ; stdcall;

procedure VCDigConfig ;
var aproc : TVCDigConfig;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDigConfig');
  if @aproc <> nil then
      aproc;
end;

type TVCDigDrawingAlign = procedure ; stdcall;

procedure VCDigDrawingAlign ;
var aproc : TVCDigDrawingAlign;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDigDrawingAlign');
  if @aproc <> nil then
      aproc;
end;

type TVCDimEdit = procedure ; stdcall;

procedure VCDimEdit ;
var aproc : TVCDimEdit;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimEdit');
  if @aproc <> nil then
      aproc;
end;

type TVCDimMoveArc = procedure ; stdcall;

procedure VCDimMoveArc ;
var aproc : TVCDimMoveArc;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimMoveArc');
  if @aproc <> nil then
      aproc;
end;

type TVCDimMoveLine = procedure ; stdcall;

procedure VCDimMoveLine ;
var aproc : TVCDimMoveLine;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimMoveLine');
  if @aproc <> nil then
      aproc;
end;

type TVCDimMoveText = procedure ; stdcall;

procedure VCDimMoveText ;
var aproc : TVCDimMoveText;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimMoveText');
  if @aproc <> nil then
      aproc;
end;

type TVCDimPoint = procedure (var iError: smallint); stdcall;

procedure VCDimPoint (var iError: smallint);
var aproc : TVCDimPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimPoint');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCDimSlideText = procedure ; stdcall;

procedure VCDimSlideText ;
var aproc : TVCDimSlideText;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimSlideText');
  if @aproc <> nil then
      aproc;
end;

type TVCDispatchCommand = procedure ; stdcall;

procedure VCDispatchCommand ;
var aproc : TVCDispatchCommand;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDispatchCommand');
  if @aproc <> nil then
      aproc;
end;

type TVCDispatchNextPoint = procedure ; stdcall;

procedure VCDispatchNextPoint ;
var aproc : TVCDispatchNextPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDispatchNextPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCDllRun = procedure (var iError: smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar); stdcall;

procedure VCDllRun (var iError: smallint; DllName: PChar; FunctionName: PChar; CommandLine: PChar);
var aproc : TVCDllRun;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDllRun');
  if @aproc <> nil then
      aproc(iError, DllName, FunctionName, CommandLine);
end;

type TVCEdit = procedure ; stdcall;

procedure VCEdit ;
var aproc : TVCEdit;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEdit');
  if @aproc <> nil then
      aproc;
end;

type TVCEditAbort = procedure ; stdcall;

procedure VCEditAbort ;
var aproc : TVCEditAbort;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEditAbort');
  if @aproc <> nil then
      aproc;
end;

type TVCEditChange = procedure ; stdcall;

procedure VCEditChange ;
var aproc : TVCEditChange;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEditChange');
  if @aproc <> nil then
      aproc;
end;

type TVCEditComplete = procedure ; stdcall;

procedure VCEditComplete ;
var aproc : TVCEditComplete;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEditComplete');
  if @aproc <> nil then
      aproc;
end;

type TVCEllipse = procedure ; stdcall;

procedure VCEllipse ;
var aproc : TVCEllipse;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEllipse');
  if @aproc <> nil then
      aproc;
end;

type TVCEllipticalArcStartSpan = procedure ; stdcall;

procedure VCEllipticalArcStartSpan ;
var aproc : TVCEllipticalArcStartSpan;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEllipticalArcStartSpan');
  if @aproc <> nil then
      aproc;
end;

type TVCEraseLast = procedure ; stdcall;

procedure VCEraseLast ;
var aproc : TVCEraseLast;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEraseLast');
  if @aproc <> nil then
      aproc;
end;

type TVCEraseSelected = procedure ; stdcall;

procedure VCEraseSelected ;
var aproc : TVCEraseSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCEraseSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCExplode = procedure ; stdcall;

procedure VCExplode ;
var aproc : TVCExplode;
begin
  @aproc :=  GetProcAddress(hInst, 'VCExplode');
  if @aproc <> nil then
      aproc;
end;

type TVCExtend = procedure ; stdcall;

procedure VCExtend ;
var aproc : TVCExtend;
begin
  @aproc :=  GetProcAddress(hInst, 'VCExtend');
  if @aproc <> nil then
      aproc;
end;

type TVCFillSelected = procedure ; stdcall;

procedure VCFillSelected ;
var aproc : TVCFillSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCFillSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCFillet = procedure ; stdcall;

procedure VCFillet ;
var aproc : TVCFillet;
begin
  @aproc :=  GetProcAddress(hInst, 'VCFillet');
  if @aproc <> nil then
      aproc;
end;

type TVCFitScaleSelected = procedure ; stdcall;

procedure VCFitScaleSelected ;
var aproc : TVCFitScaleSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCFitScaleSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCGetCurrentToolContextMenu = function (var iError: smallint; hInMenu: Longint): smallint; stdcall;

function VCGetCurrentToolContextMenu(var iError: smallint; hInMenu: Longint): smallint; stdcall;
var aproc : TVCGetCurrentToolContextMenu;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetCurrentToolContextMenu');
  if @aproc <> nil then
    result :=   aproc(iError, hInMenu);
end;


type TVCGetDatumMode = function (var iError: smallint):Smallint; stdcall;

function VCGetDatumMode (var iError: smallint):Smallint;
var aproc : TVCGetDatumMode;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetDatumMode');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetPrompt = function (iPromptIndex: smallint; szPrompt: PChar):Smallint; stdcall;

function VCGetPrompt (iPromptIndex: smallint; szPrompt: PChar):Smallint;
var aproc : TVCGetPrompt;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPrompt');
  if @aproc <> nil then
    result :=   aproc(iPromptIndex, szPrompt);
end;

type TVCGetRibbolog = function :Smallint; stdcall;

function VCGetRibbolog :Smallint;
var aproc : TVCGetRibbolog;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetRibbolog');
  if @aproc <> nil then
    result :=   aproc;
end;

type TVCGetToolID = function :Smallint; stdcall;

function VCGetToolID :Smallint;
var aproc : TVCGetToolID;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetToolID');
  if @aproc <> nil then
    result :=   aproc;
end;

type TVCGetUserToolState = function (var iError: smallint):Smallint; stdcall;

function VCGetUserToolState (var iError: smallint):Smallint;
var aproc : TVCGetUserToolState;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetUserToolState');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGridOrigin = procedure ; stdcall;

procedure VCGridOrigin ;
var aproc : TVCGridOrigin;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGridOrigin');
  if @aproc <> nil then
      aproc;
end;

type TVCHatchSelected = procedure ; stdcall;

procedure VCHatchSelected ;
var aproc : TVCHatchSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCHatchSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCIrregularPolygon = procedure ; stdcall;

procedure VCIrregularPolygon ;
var aproc : TVCIrregularPolygon;
begin
  @aproc :=  GetProcAddress(hInst, 'VCIrregularPolygon');
  if @aproc <> nil then
      aproc;
end;

type TVCLeader = procedure ; stdcall;

procedure VCLeader ;
var aproc : TVCLeader;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLeader');
  if @aproc <> nil then
      aproc;
end;

type TVCLeaderEdit = procedure ; stdcall;

procedure VCLeaderEdit ;
var aproc : TVCLeaderEdit;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLeaderEdit');
  if @aproc <> nil then
      aproc;
end;

type TVCLike = procedure (hw: Longint; ch: PChar); stdcall;

procedure VCLike (hw: Longint; ch: PChar);
var aproc : TVCLike;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLike');
  if @aproc <> nil then
      aproc(hw, ch);
end;

type TVCLine = procedure ; stdcall;

procedure VCLine ;
var aproc : TVCLine;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLine');
  if @aproc <> nil then
      aproc;
end;

type TVCLineContinuous = procedure ; stdcall;

procedure VCLineContinuous ;
var aproc : TVCLineContinuous;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLineContinuous');
  if @aproc <> nil then
      aproc;
end;

type TVCLinearDim = procedure ; stdcall;

procedure VCLinearDim ;
var aproc : TVCLinearDim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLinearDim');
  if @aproc <> nil then
      aproc;
end;

type TVCLoadAscii = procedure (var iError: smallint; szAscii: PChar); stdcall;

procedure VCLoadAscii (var iError: smallint; szAscii: PChar);
var aproc : TVCLoadAscii;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadAscii');
  if @aproc <> nil then
      aproc(iError, szAscii);
end;

type TVCLoadLnt = procedure ; stdcall;

procedure VCLoadLnt ;
var aproc : TVCLoadLnt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadLnt');
  if @aproc <> nil then
      aproc;
end;

type TVCMButtonDown = procedure (lParam: Longint; wParam: smallint); stdcall;

procedure VCMButtonDown (lParam: Longint; wParam: smallint);
var aproc : TVCMButtonDown;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMButtonDown');
  if @aproc <> nil then
      aproc(lParam, wParam);
end;

type TVCMLine = procedure ; stdcall;

procedure VCMLine ;
var aproc : TVCMLine;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMLine');
  if @aproc <> nil then
      aproc;
end;

type TVCMatchEntity = procedure ; stdcall;

procedure VCMatchEntity ;
var aproc : TVCMatchEntity;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMatchEntity');
  if @aproc <> nil then
      aproc;
end;

type TVCMatchTool = procedure ; stdcall;

procedure VCMatchTool ;
var aproc : TVCMatchTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMatchTool');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureAngle2 = procedure ; stdcall;

procedure VCMeasureAngle2 ;
var aproc : TVCMeasureAngle2;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureAngle2');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureAngle3 = procedure ; stdcall;

procedure VCMeasureAngle3 ;
var aproc : TVCMeasureAngle3;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureAngle3');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureArea = procedure ; stdcall;

procedure VCMeasureArea ;
var aproc : TVCMeasureArea;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureArea');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureDistance = procedure ; stdcall;

procedure VCMeasureDistance ;
var aproc : TVCMeasureDistance;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureDistance');
  if @aproc <> nil then
      aproc;
end;

type TVCMerge = procedure (pName: PChar); stdcall;

procedure VCMerge (pName: PChar);
var aproc : TVCMerge;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMerge');
  if @aproc <> nil then
      aproc(pName);
end;

type TVCMergePolygonsTool = procedure (var iError: smallint); stdcall;

procedure VCMergePolygonsTool(var iError: smallint); stdcall;
var aproc : TVCMergePolygonsTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMergePolygonsTool');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCMirrorSelected = procedure ; stdcall;

procedure VCMirrorSelected ;
var aproc : TVCMirrorSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMirrorSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCModBreak = procedure ; stdcall;

procedure VCModBreak ;
var aproc : TVCModBreak;
begin
  @aproc :=  GetProcAddress(hInst, 'VCModBreak');
  if @aproc <> nil then
      aproc;
end;

type TVCMovePoint = procedure ; stdcall;

procedure VCMovePoint ;
var aproc : TVCMovePoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMovePoint');
  if @aproc <> nil then
      aproc;
end;

type TVCMoveSelected = procedure ; stdcall;

procedure VCMoveSelected ;
var aproc : TVCMoveSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMoveSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCMoveToLayer = procedure(var iError: smallint; iLayer: smallint); stdcall;

procedure VCMoveToLayer(var iError: smallint; iLayer: smallint); stdcall;
var aproc : TVCMoveToLayer;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMoveToLayer');
  if @aproc <> nil then
      aproc(iError, iLayer);
end;

type TVCMultipleCopy = procedure ; stdcall;

procedure VCMultipleCopy ;
var aproc : TVCMultipleCopy;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMultipleCopy');
  if @aproc <> nil then
      aproc;
end;

type TVCNewHandle = procedure ; stdcall;

procedure VCNewHandle ;
var aproc : TVCNewHandle;
begin
  @aproc :=  GetProcAddress(hInst, 'VCNewHandle');
  if @aproc <> nil then
      aproc;
end;

type TVCOffsetMEP = procedure (var iError: smallint); stdcall;

procedure VCOffsetMEP (var iError: smallint);
var aproc : TVCOffsetMEP;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOffsetMEP');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCOffsetPnt = procedure ; stdcall;

procedure VCOffsetPnt ;
var aproc : TVCOffsetPnt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOffsetPnt');
  if @aproc <> nil then
      aproc;
end;

type TVCOleClassMethodInvoke = procedure (var iError: smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar); stdcall;

procedure VCOleClassMethodInvoke (var iError: smallint; DllName: PChar; ClassName: PChar; MethodName: PChar; CmdLine: PChar);
var aproc : TVCOleClassMethodInvoke;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOleClassMethodInvoke');
  if @aproc <> nil then
      aproc(iError, DllName, ClassName, MethodName, CmdLine);
end;

type TVCOrdinateDim = procedure (var iError: smallint); stdcall;

procedure VCOrdinateDim (var iError: smallint);
var aproc : TVCOrdinateDim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOrdinateDim');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCPackData = procedure (hW: Longint); stdcall;

procedure VCPackData (hW: Longint);
var aproc : TVCPackData;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPackData');
  if @aproc <> nil then
      aproc(hW);
end;

type TVCPastable = function :wordbool; stdcall;

function VCPastable :wordbool;
var aproc : TVCPastable;
begin
    result := wordbool(0);
  @aproc :=  GetProcAddress(hInst, 'VCPastable');
  if @aproc <> nil then
    result :=   aproc;
end;

type TVCPaste = procedure ; stdcall;

procedure VCPaste ;
var aproc : TVCPaste;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPaste');
  if @aproc <> nil then
      aproc;
end;

type TVCPlaceCurrentSymbol = procedure ; stdcall;

procedure VCPlaceCurrentSymbol ;
var aproc : TVCPlaceCurrentSymbol;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPlaceCurrentSymbol');
  if @aproc <> nil then
      aproc;
end;

type TVCPoint = procedure ; stdcall;

procedure VCPoint ;
var aproc : TVCPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCPopupButton = procedure (lParam: Longint; wParam: smallint); stdcall;

procedure VCPopupButton (lParam: Longint; wParam: smallint);
var aproc : TVCPopupButton;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPopupButton');
  if @aproc <> nil then
      aproc(lParam, wParam);
end;

type TVCPurgeLnt = procedure ; stdcall;

procedure VCPurgeLnt ;
var aproc : TVCPurgeLnt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPurgeLnt');
  if @aproc <> nil then
      aproc;
end;

type TVCRButtonDown = procedure (lParam: Longint; wParam: smallint); stdcall;

procedure VCRButtonDown (lParam: Longint; wParam: smallint);
var aproc : TVCRButtonDown;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRButtonDown');
  if @aproc <> nil then
      aproc(lParam, wParam);
end;

type TVCRFSize = procedure (var iError: smallint); stdcall;

procedure VCRFSize (var iError: smallint);
var aproc : TVCRFSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFSize');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomAll = procedure (var iError: smallint); stdcall;

procedure VCRFZoomAll (var iError: smallint);
var aproc : TVCRFZoomAll;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomAll');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomArea = procedure (var iError: smallint); stdcall;

procedure VCRFZoomArea (var iError: smallint);
var aproc : TVCRFZoomArea;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomArea');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomIn = procedure (var iError: smallint); stdcall;

procedure VCRFZoomIn (var iError: smallint);
var aproc : TVCRFZoomIn;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomIn');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomOut = procedure (var iError: smallint); stdcall;

procedure VCRFZoomOut (var iError: smallint);
var aproc : TVCRFZoomOut;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomOut');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomPan = procedure (var iError: smallint); stdcall;

procedure VCRFZoomPan (var iError: smallint);
var aproc : TVCRFZoomPan;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomPan');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomPrevious = procedure (var iError: smallint); stdcall;

procedure VCRFZoomPrevious (var iError: smallint);
var aproc : TVCRFZoomPrevious;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomPrevious');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomRegen = procedure (var iError: smallint); stdcall;

procedure VCRFZoomRegen (var iError: smallint);
var aproc : TVCRFZoomRegen;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomRegen');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomValue = procedure (var iError: smallint); stdcall;

procedure VCRFZoomValue (var iError: smallint);
var aproc : TVCRFZoomValue;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomValue');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFZoomView = procedure (var iError: smallint); stdcall;

procedure VCRFZoomView (var iError: smallint);
var aproc : TVCRFZoomView;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFZoomView');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRPolygonCenter = procedure ; stdcall;

procedure VCRPolygonCenter ;
var aproc : TVCRPolygonCenter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRPolygonCenter');
  if @aproc <> nil then
      aproc;
end;

type TVCRPolygonSide = procedure ; stdcall;

procedure VCRPolygonSide ;
var aproc : TVCRPolygonSide;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRPolygonSide');
  if @aproc <> nil then
      aproc;
end;

type TVCRadCopySelected = procedure ; stdcall;

procedure VCRadCopySelected ;
var aproc : TVCRadCopySelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRadCopySelected');
  if @aproc <> nil then
      aproc;
end;

type TVCRadialDim = procedure ; stdcall;

procedure VCRadialDim ;
var aproc : TVCRadialDim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRadialDim');
  if @aproc <> nil then
      aproc;
end;

type TVCRectangle2Pt = procedure ; stdcall;

procedure VCRectangle2Pt ;
var aproc : TVCRectangle2Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRectangle2Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCRectangle3Pt = procedure ; stdcall;

procedure VCRectangle3Pt ;
var aproc : TVCRectangle3Pt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRectangle3Pt');
  if @aproc <> nil then
      aproc;
end;

type TVCRedo = procedure ; stdcall;

procedure VCRedo ;
var aproc : TVCRedo;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRedo');
  if @aproc <> nil then
      aproc;
end;

type TVCRefFrameCreate = procedure (var iError: smallint); stdcall;

procedure VCRefFrameCreate (var iError: smallint);
var aproc : TVCRefFrameCreate;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRefFrameCreate');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRefFramePlace = procedure (var iError: smallint); stdcall;

procedure VCRefFramePlace (var iError: smallint);
var aproc : TVCRefFramePlace;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRefFramePlace');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRegenArea = procedure ; stdcall;

procedure VCRegenArea ;
var aproc : TVCRegenArea;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRegenArea');
  if @aproc <> nil then
      aproc;
end;

type TVCReplaceSymbol = procedure (szFrom: PChar; szTo: PChar; tfSelectedOnly: wordbool); stdcall;

procedure VCReplaceSymbol (szFrom: PChar; szTo: PChar; tfSelectedOnly: wordbool);
var aproc : TVCReplaceSymbol;
begin
  @aproc :=  GetProcAddress(hInst, 'VCReplaceSymbol');
  if @aproc <> nil then
      aproc(szFrom, szTo, tfSelectedOnly);
end;

type TVCRotateSelected = procedure ; stdcall;

procedure VCRotateSelected ;
var aproc : TVCRotateSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRotateSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCRun = procedure (szName: PChar); stdcall;

procedure VCRun (szName: PChar);
var aproc : TVCRun;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRun');
  if @aproc <> nil then
      aproc(szName);
end;

type TVCRunNested = procedure (szName: PChar); stdcall;

procedure VCRunNested (szName: PChar);
var aproc : TVCRunNested;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRunNested');
  if @aproc <> nil then
      aproc(szName);
end;

type TVCRunNestedDll = procedure ; stdcall;

procedure VCRunNestedDll ;
var aproc : TVCRunNestedDll;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRunNestedDll');
  if @aproc <> nil then
      aproc;
end;

type TVCScaleSelected = procedure ; stdcall;

procedure VCScaleSelected ;
var aproc : TVCScaleSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCScaleSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCSeedFill = procedure ; stdcall;

procedure VCSeedFill ;
var aproc : TVCSeedFill;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSeedFill');
  if @aproc <> nil then
      aproc;
end;

type TVCSeedHatch = procedure ; stdcall;

procedure VCSeedHatch ;
var aproc : TVCSeedHatch;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSeedHatch');
  if @aproc <> nil then
      aproc;
end;

type TVCSelect = procedure ; stdcall;

procedure VCSelect ;
var aproc : TVCSelect;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelect');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectAdjoining = procedure ; stdcall;

procedure VCSelectAdjoining ;
var aproc : TVCSelectAdjoining;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectAdjoining');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectCrossingWindow = procedure ; stdcall;

procedure VCSelectCrossingWindow ;
var aproc : TVCSelectCrossingWindow;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectCrossingWindow');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectLastEntity = procedure ; stdcall;

procedure VCSelectLastEntity ;
var aproc : TVCSelectLastEntity;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectLastEntity');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectLastObject = procedure (var iError: smallint); stdcall;

procedure VCSelectLastObject (var iError: smallint);
var aproc : TVCSelectLastObject;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectLastObject');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCSelectObject = procedure ; stdcall;

procedure VCSelectObject ;
var aproc : TVCSelectObject;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectObject');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectWindow = procedure ; stdcall;

procedure VCSelectWindow ;
var aproc : TVCSelectWindow;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectWindow');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectionExtend = procedure ; stdcall;

procedure VCSelectionExtend ;
var aproc : TVCSelectionExtend;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectionExtend');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectionFilter = procedure (CmdID: smallint; id: smallint); stdcall;

procedure VCSelectionFilter (CmdID: smallint; id: smallint);
var aproc : TVCSelectionFilter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectionFilter');
  if @aproc <> nil then
      aproc(CmdID, id);
end;

type TVCSelectionRibalog = procedure (id: smallint); stdcall;

procedure VCSelectionRibalog (id: smallint);
var aproc : TVCSelectionRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectionRibalog');
  if @aproc <> nil then
      aproc(id);
end;

type TVCSelectionTrim = procedure ; stdcall;

procedure VCSelectionTrim ;
var aproc : TVCSelectionTrim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectionTrim');
  if @aproc <> nil then
      aproc;
end;

type TVCSelectionTrimSingleTarget = procedure (var iError: smallint); stdcall;

procedure VCSelectionTrimSingleTarget (var iError: smallint);
var aproc : TVCSelectionTrimSingleTarget;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSelectionTrimSingleTarget');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCSetBasepoint = procedure ; stdcall;

procedure VCSetBasepoint ;
var aproc : TVCSetBasepoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetBasepoint');
  if @aproc <> nil then
      aproc;
end;

type TVCSetDatumMode = procedure (var iError: smallint; iMode: smallint); stdcall;

procedure VCSetDatumMode (var iError: smallint; iMode: smallint);
var aproc : TVCSetDatumMode;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetDatumMode');
  if @aproc <> nil then
      aproc(iError, iMode);
end;

type TVCSetPrompt = function (iPromptIndex: smallint; szPrompt: PChar):Boolean; stdcall;

function VCSetPrompt (iPromptIndex: smallint; szPrompt: PChar):Boolean;
var aproc : TVCSetPrompt;
begin
    result := Boolean(0);
  @aproc :=  GetProcAddress(hInst, 'VCSetPrompt');
  if @aproc <> nil then
    result :=   aproc(iPromptIndex, szPrompt);
end;

type TVCSetRibbolog = procedure (id: smallint); stdcall;

procedure VCSetRibbolog (id: smallint);
var aproc : TVCSetRibbolog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetRibbolog');
  if @aproc <> nil then
      aproc(id);
end;

type TVCSetUserTool = procedure (iStates: smallint; szNativeCmd: PChar; szFirstPrompt: PChar); stdcall;

procedure VCSetUserTool (iStates: smallint; szNativeCmd: PChar; szFirstPrompt: PChar);
var aproc : TVCSetUserTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetUserTool');
  if @aproc <> nil then
      aproc(iStates, szNativeCmd, szFirstPrompt);
end;

type TVCSetUserToolState = procedure (var iError: smallint; iNewState: smallint); stdcall;

procedure VCSetUserToolState (var iError: smallint; iNewState: smallint);
var aproc : TVCSetUserToolState;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetUserToolState');
  if @aproc <> nil then
      aproc(iError, iNewState);
end;

type TVCSnapArcCenter = procedure ; stdcall;

procedure VCSnapArcCenter ;
var aproc : TVCSnapArcCenter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapArcCenter');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapCloseGeom = procedure ; stdcall;

procedure VCSnapCloseGeom ;
var aproc : TVCSnapCloseGeom;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapCloseGeom');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapClosestPoint = procedure ; stdcall;

procedure VCSnapClosestPoint ;
var aproc : TVCSnapClosestPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapClosestPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapEndPoint = procedure ; stdcall;

procedure VCSnapEndPoint ;
var aproc : TVCSnapEndPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapEndPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapInt = procedure ; stdcall;

procedure VCSnapInt ;
var aproc : TVCSnapInt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapInt');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapLastPoint = procedure (lParam: Longint; wParam: smallint); stdcall;

procedure VCSnapLastPoint (lParam: Longint; wParam: smallint);
var aproc : TVCSnapLastPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapLastPoint');
  if @aproc <> nil then
      aproc(lParam, wParam);
end;

type TVCSnapMid2Points = procedure ; stdcall;

procedure VCSnapMid2Points ;
var aproc : TVCSnapMid2Points;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapMid2Points');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapMidPoint = procedure ; stdcall;

procedure VCSnapMidPoint ;
var aproc : TVCSnapMidPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapMidPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapNearPoint = procedure (lParam: Longint; wParam: smallint); stdcall;

procedure VCSnapNearPoint (lParam: Longint; wParam: smallint);
var aproc : TVCSnapNearPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapNearPoint');
  if @aproc <> nil then
      aproc(lParam, wParam);
end;

type TVCSnapParallel = procedure ; stdcall;

procedure VCSnapParallel ;
var aproc : TVCSnapParallel;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapParallel');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapPercent = procedure ; stdcall;

procedure VCSnapPercent ;
var aproc : TVCSnapPercent;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapPercent');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapPerpendicular = procedure ; stdcall;

procedure VCSnapPerpendicular ;
var aproc : TVCSnapPerpendicular;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapPerpendicular');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapQuad = procedure ; stdcall;

procedure VCSnapQuad ;
var aproc : TVCSnapQuad;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapQuad');
  if @aproc <> nil then
      aproc;
end;

type TVCSnapTangent = procedure ; stdcall;

procedure VCSnapTangent ;
var aproc : TVCSnapTangent;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSnapTangent');
  if @aproc <> nil then
      aproc;
end;

type TVCSpecificAttributeAttach = procedure (lParam: Longint); stdcall;

procedure VCSpecificAttributeAttach (lParam: Longint);
var aproc : TVCSpecificAttributeAttach;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSpecificAttributeAttach');
  if @aproc <> nil then
      aproc(lParam);
end;

type TVCSplitPolygonTool = procedure (iError: smallint); stdcall;

procedure VCSplitPolygonTool(iError: smallint); stdcall;
var aproc : TVCSplitPolygonTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSplitPolygonTool');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCStretchSelected = procedure ; stdcall;

procedure VCStretchSelected ;
var aproc : TVCStretchSelected;
begin
  @aproc :=  GetProcAddress(hInst, 'VCStretchSelected');
  if @aproc <> nil then
      aproc;
end;

type TVCSymbolCreate = procedure ; stdcall;

procedure VCSymbolCreate ;
var aproc : TVCSymbolCreate;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymbolCreate');
  if @aproc <> nil then
      aproc;
end;

type TVCSymbolExplode = procedure ; stdcall;

procedure VCSymbolExplode ;
var aproc : TVCSymbolExplode;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymbolExplode');
  if @aproc <> nil then
      aproc;
end;

type TVCSymbolPlace = procedure (szName: PChar); stdcall;

procedure VCSymbolPlace (szName: PChar);
var aproc : TVCSymbolPlace;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymbolPlace');
  if @aproc <> nil then
      aproc(szName);
end;

type TVCTextManager = procedure ; stdcall;

procedure VCTextManager ;
var aproc : TVCTextManager;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTextManager');
  if @aproc <> nil then
      aproc;
end;

type TVCTextTool = procedure ; stdcall;

procedure VCTextTool ;
var aproc : TVCTextTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTextTool');
  if @aproc <> nil then
      aproc;
end;

type TVCTracking = procedure ; stdcall;

procedure VCTracking ;
var aproc : TVCTracking;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTracking');
  if @aproc <> nil then
      aproc;
end;

type TVCTrim = procedure ; stdcall;

procedure VCTrim ;
var aproc : TVCTrim;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTrim');
  if @aproc <> nil then
      aproc;
end;

type TVCUndo = procedure ; stdcall;

procedure VCUndo ;
var aproc : TVCUndo;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUndo');
  if @aproc <> nil then
      aproc;
end;

type TVCUndoLastVertex = procedure ; stdcall;

procedure VCUndoLastVertex ;
var aproc : TVCUndoLastVertex;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUndoLastVertex');
  if @aproc <> nil then
      aproc;
end;

type TVCUpdateTool = procedure ; stdcall;

procedure VCUpdateTool ;
var aproc : TVCUpdateTool;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUpdateTool');
  if @aproc <> nil then
      aproc;
end;

type TVCUserMatch = procedure (id: smallint); stdcall;

procedure VCUserMatch (id: smallint);
var aproc : TVCUserMatch;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUserMatch');
  if @aproc <> nil then
      aproc(id);
end;

type TVCUserPoint = procedure ; stdcall;

procedure VCUserPoint ;
var aproc : TVCUserPoint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUserPoint');
  if @aproc <> nil then
      aproc;
end;

type TVCWindowStretch = procedure ; stdcall;

procedure VCWindowStretch ;
var aproc : TVCWindowStretch;
begin
  @aproc :=  GetProcAddress(hInst, 'VCWindowStretch');
  if @aproc <> nil then
      aproc;
end;

type TVCZoomArea = procedure ; stdcall;

procedure VCZoomArea ;
var aproc : TVCZoomArea;
begin
  @aproc :=  GetProcAddress(hInst, 'VCZoomArea');
  if @aproc <> nil then
      aproc;
end;

type TVCZoomIn = procedure ; stdcall;

procedure VCZoomIn ;
var aproc : TVCZoomIn;
begin
  @aproc :=  GetProcAddress(hInst, 'VCZoomIn');
  if @aproc <> nil then
      aproc;
end;

type TVCZoomOut = procedure ; stdcall;

procedure VCZoomOut ;
var aproc : TVCZoomOut;
begin
  @aproc :=  GetProcAddress(hInst, 'VCZoomOut');
  if @aproc <> nil then
      aproc;
end;

type TVCZoomPan = procedure ; stdcall;

procedure VCZoomPan ;
var aproc : TVCZoomPan;
begin
  @aproc :=  GetProcAddress(hInst, 'VCZoomPan');
  if @aproc <> nil then
      aproc;
end;

type TVCZoomValue = procedure ; stdcall;

procedure VCZoomValue ;
var aproc : TVCZoomValue;
begin
  @aproc :=  GetProcAddress(hInst, 'VCZoomValue');
  if @aproc <> nil then
      aproc;
end;


end.